module Agent
  class HomeController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:agent) }

    def index
      weight_select = "service_requests.*, status IN ('in_progress', 'waiting_for_answer', 'waiting') AS weight"
      @service_requests = ServiceRequest.waiting
                                        .or(ServiceRequest.waiting_for_answer)
                                        .or(ServiceRequest.today)
                                        .select(weight_select)
                                        .order(weight: :desc, created_at: :desc)

      if turbo_frame_request?
        @service_requests = @service_requests.search(params[:term]) if params[:term].present?
        render partial: "agent/service_requests/search_results",
               locals: { service_requests: @service_requests, id: :agent_todays_service_requests }
      else
        render :index
      end
    end
  end
end
