module Agent
  class OpeningHoursController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:agent) }

    def update_all
      opening_hours = params.permit(opening_hours: {}).each do |p|
        p.second.permit(:open, :from, :to)
      end[:opening_hours]

      opening_hours.transform_values! do |opening_hour|
        opening_hour[:from] = Time.zone.parse(opening_hour[:from])&.iso8601
        opening_hour[:to] = Time.zone.parse(opening_hour[:to])&.iso8601
        opening_hour
      end

      OpeningHour.update(opening_hours.keys, opening_hours.values)

      flash.now[:info] = t("shared.messages.saved")
      render turbo_stream: update_flash_messages_turbo_stream
    end
  end
end
