module Agent
  class UsersController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:agent) }

    def index
      @clients = User.client.all

      if turbo_frame_request?
        @clients = @clients.search(params[:term]) if params[:term].present?
        render partial: "agent/users/search_results",
               locals: { clients: @clients }
      else
        render :index
      end
    end

    def show
      @client = User.client.find(params[:id])
    end

    def edit
      @client = User.client.find(params[:id])
    end

    def update
      @client = User.client.find(params[:id])
      @client.update(user_params)
      render "agent/users/show"
    end

    private

    def user_params
      params.require(:user).permit(
        :first_name,
        :last_name,
        :gender,
        :social_security_number,
        :license_plate,
        :phone_number,
        :place_name,
        :reschedule_contact_info,
        :editor_name,
        :reference_number,
        :shipment_id
      )
    end
  end
end
