module Client
  class ArticlesController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:client) }

    def index
      @articles = Article
      @articles = @articles.where(category_id: params[:categories]) if params[:categories]
      @articles = @articles.order(:created_at).group_by(&:category_id)
    end

    def show
      @article = Article.find(params[:id])
    end
  end
end
