class HomeController < ApplicationController
  def index
    redirect_to agent_home_path and return if current_role == :agent
    redirect_to admin_home_path and return if current_role == :admin
    redirect_to client_home_path and return if current_role == :client

    redirect_to welcome_path and return
  end

  def welcome
    @nav_disabled = true
  end

  def confirmation_sent
    @user = User.find_by(confirmation_token: params[:token])
  end

  def save_locale
    if I18n.available_locales.include?(params[:locale].to_sym)
      current_user&.update(locale: params[:locale])
      session[:locale] = params[:locale]
    end

    head :ok
  end
end
