module ApplicationHelper
  def action_path
    "#{controller_path}##{action_name}"
  end

  def icon(icon,
           text: nil,
           container_class: nil,
           icon_class: nil,
           icon_position: :left,
           data: nil)
    if text.present?
      render template: "components/icon_with_text",
             locals: { icon:, text:, container_class:, icon_class:, icon_position:, data: }
    else
      render template: "svg/#{icon}", locals: { icon_class:, data: }
    end
  end

  def merge_icon_class(icon_class, defaults)
    return defaults unless icon_class

    default_classes = defaults.split
    icon_classes = icon_class.split

    default_classes.reject! { |c| c.match?(/w-|h-/) } if icon_class.match(/w-|h-/)

    (icon_classes + default_classes).uniq.join(" ")
  end

  def service_request_status(service_request)
    render template: "components/service_request_status", locals: { service_request: }
  end

  def service_request_category_icon(category_id)
    {
      leisure: :education_solid,
      misc: :education_solid,
      work: :education_solid,
      finance: :education_solid,
      car: :education_solid,
      education: :education_solid,
      health: :education_solid,
      official_channel: :official_document_solid,
      shop: :education_solid,
      living: :education_solid
    }[category_id.to_sym]
  end

  def service_request_category(service_request, icon: true, container_class: nil)
    category_title = I18n.t("activerecord.attributes.service_request.categories.#{service_request.category_id}")
    category_icon = service_request_category_icon(service_request.category_id)

    if icon && category_icon
      icon(category_icon, text: category_title, container_class: container_class || "flex mt-4")
    else
      category_title
    end
  end
end
