import { Controller } from "@hotwired/stimulus"

export default class extends Controller {
  static targets = [ "input", "submit" ]

  clear() {
    this.inputTarget.value = ""
  }

  enable() {
    if (this.inputTarget.value.length === 0) {
      this.submitTarget.disabled = true
    } else {
      this.submitTarget.disabled = false
    }
  }

  keydown(event) {
    if (event.which == 13 && this.inputTarget.value.length === 0) {
      event.preventDefault()
      return
    }

    if (event.which == 13 && !event.shiftKey) {
      this.element.requestSubmit()
    }
  }

}
