import { Controller } from "@hotwired/stimulus"

export default class extends Controller {
  static values = {
    sender: String,
    other: String,
    senderId: String
  }

  connect() {
    const currentUserId = document.body.dataset.currentUserId

    if (currentUserId === this.senderIdValue) {
      this.element.classList.add(...this.senderValue.split(' '))
    } else {
      this.element.classList.add(...this.otherValue.split(' '))
    }
  }
}
