require_relative "boot"

require "rails/all"

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module Warteraum
  class Application < Rails::Application
    # Initialize configuration defaults for originally generated Rails version.
    config.load_defaults 7.0

    # Configuration for the application, engines, and railties goes here.
    #
    # These settings can be overridden in specific environments using the files
    # in config/environments, which are processed later.
    #
    config.time_zone = "Vienna"
    config.active_record.default_timezone = :utc

    config.i18n.available_locales = %i[de en]
    config.i18n.default_locale = :de

    config.autoload_paths << config.root.join("lib")

    config.active_job.queue_adapter = :sidekiq
  end
end
