require "sidekiq/web"

Rails.application.routes.draw do
  if Rails.env.production?
    Sidekiq::Web.use Rack::Auth::Basic do |username, password|
      sidekiq_password = Rails.application.credentials.dig(Rails.env.to_sym, :sidekiq_password)
      ActiveSupport::SecurityUtils.secure_compare(Digest::SHA256.hexdigest(username),
                                                  Digest::SHA256.hexdigest("sidekiq")) &
        ActiveSupport::SecurityUtils.secure_compare(Digest::SHA256.hexdigest(password),
                                                    Digest::SHA256.hexdigest(sidekiq_password))
    end
  end

  mount Sidekiq::Web, at: "/sidekiq"

  root "home#index"

  get "welcome", to: "home#welcome", as: :welcome

  get "client", to: "client/home#index", as: :client_home
  get "agent", to: "agent/home#index", as: :agent_home
  get "admin", to: "admin/agents#index", as: :admin_home

  post "save_locale/:locale", to: "home#save_locale", as: :save_locale
  get "confirmation_sent/:token", to: "home#confirmation_sent", as: :confirmation_sent

  devise_for :users, controllers: {
    sessions: "users/sessions",
    registrations: "users/registrations",
    confirmations: "users/confirmations"
  }

  devise_scope :user do
    get "anonymous_sign_up", to: "users/registrations#anonymous_sign_up", as: :anonymous_sign_up
    get "anonymous_create_account", to: "users/registrations#anonymous_create_account", as: :anonymous_create_account
    post "anonymous_create_account", to: "users/registrations#anonymous_create_account"
  end

  resources :messages, only: %i[create]

  namespace :client do
    resources :articles, only: %i[index show]
    resources :service_requests, only: %i[index new create show] do
      member do
        get :call
        put :finish
        put :decline
        put :accept
        put :reactivate
        patch :mute_video
        patch :mute_audio
        delete :cancel
      end
    end
    resources :users, only: %i[edit update]
  end

  namespace :agent do
    resources :articles, only: %i[new index show create edit update]
    resources :users, only: %i[index show edit update]
    resource :service_center, only: [:update]
    resources :service_requests, except: %i[edit destroy] do
      member do
        get :call
        put :finish
        get :switch
        get :other_requests
        patch :mute_video
        patch :mute_audio
        delete :cancel
      end
    end

    get "settings", to: "settings#index", as: :settings
    patch "settings", to: "settings#update"

    resources :opening_hours, only: [] do
      collection do
        post :update_all
      end
    end
  end

  namespace :admin do
    resources :agents, except: %i[show destroy]
    resources :clients, only: [:index]
    resources :service_requests, only: [:index]
    resources :holidays, only: [:index] do
      collection do
        post "import"
      end
    end
  end
end
