const defaultTheme = require('tailwindcss/defaultTheme')

module.exports = {
  content: [
    './app/helpers/**/*.rb',
    './app/javascript/**/*.js',
    './app/views/**/*',
  ],
  theme: {
    extend: {
      colors: {
        'blue': '#00A4BD',
        'blue-100': "#CCE6EA",
        'blue-200': "#13889D",
        'blue-300': "#AEDBE2",
        'blue-400': "#1AA4BB",
        'blue-500': "rgb(203, 239, 245)",
        'blue-600': "#63B2BE",
        'gray': '#E6E6E6',
        'gray-100': '#A5A5A5',
        'gray-200': '#4D4D4D',
        'gray-300': "#F5F5F5",
        'gray-400': "rgb(128, 128, 128)",
        'orange-200': "rgb(248, 166, 83)",
        'orange-700': "rgb(123, 82, 40)",
      },
      fontFamily: {
        sans: ['Barlow', ...defaultTheme.fontFamily.sans],
      },
      backgroundImage: {
        'woman': "linear-gradient(rgba(222, 222, 222, 0.8), rgba(222, 222, 222, 0.8)), url('woman.png')"
      }
    },
  },
  plugins: [
    require('@tailwindcss/forms'),
    require('@tailwindcss/aspect-ratio'),
    require('@tailwindcss/typography')
  ]
}
