describe('Login', function() {
  beforeEach(() => {
    cy.app('clean')
  })

  it('with an agent', function() {
    cy.appFixtures()
    cy.visit('/')

    cy.get('a').contains("Login").click()
    cy.get('input[id=user_email]').type("agent@warteraum.dev")
    cy.get('input[id=user_password]').type(`test1234{enter}`)

    cy.url().should('include', '/agent')
    cy.get("#flash_messages").should('contain.text', 'Signed in successfully.')
  })

  it('with a client', function() {
    cy.appFixtures()
    cy.visit('/')

    cy.get('a').contains("Login").click()
    cy.get('input[id=user_email]').type("client@warteraum.dev")
    cy.get('input[id=user_password]').type(`test1234{enter}`)

    cy.url().should('include', '/client')
    cy.get("#flash_messages").should('contain.text', 'Signed in successfully.')
  })
})
