describe('Service requests', function() {
  beforeEach(() => {
    cy.app('clean')
    cy.login('client@warteraum.dev', 'test1234')
  })

  it('create new request', function() {
    cy.appFixtures()
    cy.visit('/')

    cy.get("#new_service_request_button").click()

    cy.vcr_insert_cassette('service_requests', { record: "once" })

    cy.get("#service_request_category_id").select(2)
    cy.get("#service_request_title").type("new service request test title")
    cy.get("#service_request_description").type("new service request test description")
    cy.get("#user_phone_number").type("123-456{enter}")

    cy.url().should('include', "/client")
    cy.get('main').should('include.text', "new service request test title")

    cy.login('agent@warteraum.dev', 'test1234')
    cy.visit('/')

    cy.get('#agent_todays_service_requests').should('include.text', 'new service request test title')
    cy.get('#agent_todays_service_requests').should('include.text', 'new service request test description')

    cy.vcr_eject_cassette()
  })
})
