class AddNewFieldsToUsers < ActiveRecord::Migration[7.0]
  def change
    change_table :users, bulk: true do |t|
      t.string :role, default: :client, null: false
      t.string :first_name
      t.string :last_name
      t.string :locale, default: :de, null: false
      t.string :gender
      t.string :license_plate
      t.string :phone_number
      t.string :social_security_number
      t.string :address
      t.boolean :anonymous, default: false
      t.boolean :can_close_service_center, default: false
      t.datetime :last_seen_at
    end
  end
end
