class CreateServiceRequests < ActiveRecord::Migration[7.0]
  def change
    create_table :service_requests, id: :uuid do |t|
      t.belongs_to :client, type: :uuid
      t.belongs_to :agent, type: :uuid
      t.string :status, default: :waiting
      t.column :category_id, :string, null: false
      t.column :title, :string, null: false
      t.string :description
      t.column :internal_comment, :string
      t.datetime :call_started_at
      t.datetime :call_ended_at
      t.integer :call_duration
      t.string :janus_videoroom_pin
      t.boolean :is_agent_video_muted, default: false
      t.boolean :is_agent_audio_muted, default: false
      t.boolean :is_client_video_muted, default: false
      t.boolean :is_client_audio_muted, default: false
      t.timestamps
    end
  end
end
