namespace :janus do
  desc "Cleans up auth tokens"
  task cleanup_auth_tokens: :environment do
    tokens = JanusApi.list_tokens
    tokens = tokens["data"]["tokens"].filter_map do |token|
      token["token"] if token["token"].split(",").first.to_datetime + 3.days < Time.current
    end
    tokens.each { |t| JanusApi.remove_token(t) }
  end

  desc "Cleans up orphaned videorooms"
  task cleanup_videorooms: :environment do
    ServiceRequest.where("created_at < ?", Date.current - 1.day)
                  .where.not(janus_videoroom_pin: nil).each(&:destroy_janus_videoroom!)
  end
end
