require "test_helper"

module Agent
  class ArticlesControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "new" do
      sign_in users(:agent)

      get new_agent_article_path

      assert_response :ok
    end

    test "create" do
      sign_in users(:agent)

      post agent_articles_path, params: {
        article: {
          category_id: "finance",
          title: "created",
          content: "description"
        }
      }

      assert_equal "created", Article.last.title

      assert_response :ok
    end

    test "index" do
      sign_in users(:agent)

      get agent_articles_path

      assert_response :ok
    end

    test "show" do
      sign_in users(:agent)

      article = articles(:one)

      get agent_article_path(article)

      assert_response :ok
    end

    test "update" do
      sign_in users(:agent)

      article = articles(:one)

      put agent_article_path(article), params: {
        article: {
          title: "new title"
        }
      }

      assert_equal "new title", article.reload.title

      assert_response :ok
    end
  end
end
