require "test_helper"

module Agent
  class OpeningHoursControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "update all" do
      sign_in users(:agent)

      o1 = opening_hours(:monday)
      o2 = opening_hours(:tuesday)

      post update_all_agent_opening_hours_path, params: {
        opening_hours: {
          o1.id => {
            open: true,
            from: "08:00:00.000",
            to: "18:00:00.000"
          },
          o2.id => {
            open: false,
            from: "09:00:00.000",
            to: "19:00:00.000"
          }
        }
      }

      oh1 = OpeningHour.find_by(id: o1.id)
      oh2 = OpeningHour.find_by(id: o2.id)

      assert_equal true, oh1.open
      assert_equal "08:00", oh1.from.strftime("%H:%M")
      assert_equal "18:00", oh1.to.strftime("%H:%M")
      assert_equal false, oh2.open
      assert_equal "09:00", oh2.from.strftime("%H:%M")
      assert_equal "19:00", oh2.to.strftime("%H:%M")
    end
  end
end
