require "test_helper"

module Client
  class ServiceRequestsControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers
    include ActionCable::TestHelper

    test "should fail with invalid params" do
      sign_in users(:client)

      post client_service_requests_url, params: {
        service_request: {
          title: "test"
        },
        user: {
          license_plate: "test"
        }
      }

      assert_response :unprocessable_entity
    end

    test "should create new service request and broadcast to channels" do
      sign_in users(:client)

      post client_service_requests_url, params: {
        service_request: {
          category_id: 1,
          title: "test",
          description: "test"
        },
        user: {
          license_plate: "test"
        }
      }

      assert_redirected_to client_home_url

      assert_broadcasts "agent:todays_service_requests", 1
      assert_broadcasts "agent:all_service_requests", 1
    end

    test "accept" do
      sign_in users(:client)

      service_request = service_requests(:waiting_for_answer)

      put accept_client_service_request_path(service_request)

      assert_equal "in_progress", service_request.reload.status

      assert_response :no_content
    end

    test "decline" do
      sign_in users(:client)

      service_request = service_requests(:in_progress)

      put decline_client_service_request_path(service_request)

      assert_equal "waiting", service_request.reload.status

      assert_broadcasts "agent:todays_service_requests", service_request.agent.agent_service_requests.count
      assert_broadcasts "agent:all_service_requests", service_request.agent.agent_service_requests.count

      assert_redirected_to client_home_path
    end

    test "call" do
      sign_in users(:client)

      service_request = service_requests(:one)

      get call_client_service_request_path(service_request)

      assert_response :ok
    end

    test "call redirects to home for finished service requests" do
      sign_in users(:client)

      service_request = service_requests(:finished)

      get call_client_service_request_path(service_request)

      assert_redirected_to client_home_path
    end
  end
end
