require "test_helper"

class MessagesControllerTest < ActionDispatch::IntegrationTest
  include Devise::Test::IntegrationHelpers

  test "should create a new message" do
    service_request = service_requests(:one)
    sign_in users(:client)

    assert_difference "Message.count", 1 do
      post messages_path, params: {
        service_request_id: service_request.id,
        message: { text: "test" }
      }
    end

    created_message = Message.last

    assert_equal created_message.text, "test"
    assert_equal created_message.service_request_id, service_request.id
  end
end
