require "test_helper"

class ServiceCenterTest < ActiveSupport::TestCase
  test "opening hours label when Service center is closed" do
    service_center = service_centers(:service_center)
    service_center.update(open: false)

    # Wednesday/Thursday is holiday
    Holiday.create!(date: "2022-07-27", name: "test1", service_center:)
    Holiday.create!(date: "2022-07-28", name: "test2", service_center:)

    # Sunday
    mock_pg_time Time.zone.parse("2022-07-24 08:00") do
      assert_equal "Service center opens Monday at 09:00", ServiceCenter.opening_hours_label
    end

    # Monday
    mock_pg_time Time.zone.parse("2022-07-25 08:00") do
      assert_equal "Service center opens today at 09:00", ServiceCenter.opening_hours_label
    end

    # Monday
    mock_pg_time Time.zone.parse("2022-07-25 19:00") do
      assert_equal "Service center opens Tuesday at 09:00", ServiceCenter.opening_hours_label
    end

    # Wednesday
    mock_pg_time Time.zone.parse("2022-07-27 08:00") do
      assert_equal "Service center opens Friday at 09:00", ServiceCenter.opening_hours_label
    end
  end

  test "schedule opening job of service center" do
    mock_pg_time Time.zone.parse("2022-07-27 00:00") do
      assert_equal OpeningHour.next_open["from"], Time.zone.at(ServiceCenter.schedule_open_job.scheduled_at)
    end
  end
end
