module Agent
  class SettingsController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:agent) }

    def index
      @opening_hours = OpeningHour.week_days
      @user = current_user
    end

    def update
      @opening_hours = OpeningHour.week_days
      @user = current_user

      if @user.update(user_params)
        flash.now[:info] = t("shared.messages.saved")
        redirect_to agent_settings_path
      else
        render "agent/settings/index", status: :unprocessable_entity
      end
    end

    private

    def user_params
      permitted_attributes = %i[first_name last_name avatar locale]
      permitted_attributes += %i[password password_confirmation] if params.dig(:user, :password).present?

      params.require(:user).permit(permitted_attributes)
    end
  end
end
