module Client
  class UsersController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:client) }

    def edit
      @user = current_user
    end

    def update
      current_user.update(user_params)

      flash.now[:info] = t(".saved")
      render turbo_stream: update_flash_messages_turbo_stream
    end

    private

    def user_params
      params.require(:user).permit(
        :first_name,
        :last_name,
        :address,
        :gender,
        :social_security_number,
        :license_plate,
        :phone_number,
        :place_name,
        :reschedule_contact_info,
        :editor_name,
        :reference_number,
        :shipment_id
      )
    end
  end
end
