import { Controller } from '@hotwired/stimulus'
import { Turbo } from '@hotwired/turbo-rails'

export default class extends Controller {
  connect() {
    if (this.element.tagName === "TEMPLATE") {
      if (this.element.dataset.url) {
        location.href = this.element.dataset.url
        this.element.remove()
      } else {
        this.element.remove()
        this.reload()
      }
    }
  }

  reload() {
    location.reload()
  }
}
