import { Controller } from "@hotwired/stimulus"

export default class extends Controller {

  connect() {
    this.showAlwaysVisibleFields()
  }

  showAlwaysVisibleFields() {
    if (this.element.querySelector("#user_first_name")) {
      this.element.querySelector("#user_first_name").parentElement.classList.remove('hidden')
    }
    this.element.querySelector("#user_phone_number").parentElement.classList.remove('hidden')
    this.element.querySelector("#user_place_name").parentElement.classList.remove('hidden')
  }

  categoryChanged(event) {
    this.element.querySelectorAll("[id*='user_']").forEach((e) => {
      e.parentElement.classList.add("hidden")
    })
    this.showAlwaysVisibleFields()

    if (event.target.value === "car") {
      this.element.querySelector("#user_license_plate").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "education") {
      this.element.querySelector("#user_social_security_number").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "health") {
      this.element.querySelector("#user_reschedule_contact_info").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_social_security_number").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "shop") {
      this.element.querySelector("#user_reference_number").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "official_channel") {
      this.element.querySelector("#user_address").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_social_security_number").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_editor_name").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_reference_number").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "work") {
      this.element.querySelector("#user_editor_name").parentElement.classList.remove("hidden")
    }

    if (event.target.value === "living") {
      this.element.querySelector("#user_editor_name").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_address").parentElement.classList.remove("hidden")
      this.element.querySelector("#user_reference_number").parentElement.classList.remove("hidden")
    }
  }
}
