require "test_helper"

module Agent
  class ServiceCenterControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "returns unauthorized without permission" do
      service_center = service_centers(:service_center)

      sign_in users(:agent)

      put agent_service_center_path, params: {
        service_center: { open: false }
      }

      assert_equal true, service_center.open

      assert_response :unauthorized
    end

    test "updates open state of service center" do
      service_center = service_centers(:service_center)

      sign_in users(:agent_with_close_permission)

      put agent_service_center_path, params: {
        service_center: { open: false }
      }

      assert_equal false, service_center.reload.open

      assert_response :ok
    end
  end
end
