require "test_helper"

module Agent
  class SettingsControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "renders index" do
      sign_in users(:agent)

      get agent_settings_path

      assert_response :ok
    end

    test "updates settings" do
      sign_in agent = users(:agent)

      assert_equal "Agent", agent.first_name

      patch agent_settings_path, params: {
        user: {
          first_name: "updated"
        }
      }

      assert_equal "updated", agent.first_name

      assert_redirected_to agent_settings_path
    end
  end
end
