require "test_helper"

module Agent
  class UsersControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "renders index" do
      sign_in users(:agent)

      get agent_users_path

      assert_response :ok
    end

    test "renders show" do
      sign_in users(:agent)
      client = users(:client)

      get agent_user_path(client)

      assert_response :ok
    end

    test "renders edit" do
      sign_in users(:agent)
      client = users(:client)

      get edit_agent_user_path(client)

      assert_response :ok
    end

    test "updates the client" do
      sign_in users(:agent)
      client = users(:client)

      assert_equal "Client", client.first_name

      put agent_user_path(client), params: {
        id: client.id,
        user: {
          first_name: "updated"
        }
      }

      assert_equal "updated", client.reload.first_name

      assert_response :ok
    end
  end
end
