require "test_helper"

module Client
  class ArticlesControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "redirects to login page" do
      get client_articles_path

      assert_redirected_to new_user_session_path
    end

    test "renders index" do
      sign_in users(:client)

      get client_articles_path

      assert_response :ok
    end

    test "renders show" do
      sign_in users(:client)

      article = articles(:one)

      get client_article_path(article)

      assert_response :ok
    end
  end
end
