require "test_helper"

class HomeControllerTest < ActionDispatch::IntegrationTest
  include Devise::Test::IntegrationHelpers

  test "should redirect to welcome" do
    get root_url
    assert_redirected_to welcome_path
  end

  test "should redirect to client home" do
    sign_in users(:client)
    get root_url
    assert_redirected_to client_home_path
  end

  test "should redirect to agent home" do
    sign_in users(:agent)
    get root_url
    assert_redirected_to agent_home_path
  end

  test "should redirect to admin home" do
    sign_in users(:admin)
    get root_url
    assert_redirected_to admin_home_path
  end

  test "confirmation_sent" do
    users(:unconfirmed_client)
    get confirmation_sent_url(token: :token)
    assert_response :success
  end
end
