require "test_helper"

module Users
  class RegistrationsControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "should create anonymous user" do
      get anonymous_sign_up_path
      assert_redirected_to root_path
    end

    test "should return unauthorized if user is not logged in" do
      post anonymous_create_account_path, params: {
        user: {
          first_name: "first",
          last_name: "last",
          email: "email@test.com",
          gender: "male",
          password: "test",
          password_confirmation: "test"
        }
      }

      assert_response :unauthorized
    end

    test "should create user account" do
      sign_in users(:client)

      assert_difference "User.client.count", 1 do
        post anonymous_create_account_path, params: {
          user: {
            first_name: "first",
            last_name: "last",
            email: "email@test.com",
            gender: "male",
            password: "test1234",
            password_confirmation: "test1234"
          }
        }
      end

      created_user = User.client.last
      assert_redirected_to confirmation_sent_path(created_user.confirmation_token)
    end
  end
end
