require "test_helper"

class OpeningHourTest < ActiveSupport::TestCase
  test "opening hour logic" do
    service_center = service_centers(:service_center)

    # Monday/Tuesday is holiday
    Holiday.create!(date: "2022-07-25", name: "test1", service_center:)
    Holiday.create!(date: "2022-07-26", name: "test2", service_center:)

    # Sunday
    mock_pg_time Time.zone.parse("2022-07-24 06:00") do
      assert_equal 3, OpeningHour.next_open["week_day"]
      assert_equal Time.zone.parse("2022-07-27 09:00"), OpeningHour.next_open["from"]
    end

    # Tuesday
    mock_pg_time Time.zone.parse("2022-07-26 08:00") do
      assert_equal 3, OpeningHour.next_open["week_day"]
      assert_equal Time.zone.parse("2022-07-27 09:00"), OpeningHour.next_open["from"]
    end

    # Wednesday
    mock_pg_time Time.zone.parse("2022-07-27 08:00") do
      assert_equal 3, OpeningHour.next_open["week_day"]
      assert_equal Time.zone.parse("2022-07-27 09:00"), OpeningHour.next_open["from"]
    end

    # Wednesday
    mock_pg_time Time.zone.parse("2022-07-27 19:00") do
      assert_equal 4, OpeningHour.next_open["week_day"]
      assert_equal Time.zone.parse("2022-07-28 09:00"), OpeningHour.next_open["from"]
    end

    # Thursday
    mock_pg_time Time.zone.parse("2022-07-28 08:00") do
      assert_equal 4, OpeningHour.next_open["week_day"]
      assert_equal Time.zone.parse("2022-07-28 09:00"), OpeningHour.next_open["from"]
    end
  end
end
