module Admin
  class ClientsController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:admin) }

    def index
      @clients = User.client.all

      if turbo_frame_request?
        @clients = @clients.search(params[:term]) if params[:term].present?
        render partial: "admin/clients/search_results",
               locals: { clients: @clients }
      else
        render :index
      end
    end
  end
end
