module Admin
  class HolidaysController < ApplicationController
    before_action :authenticate_user!
    before_action -> { authenticate_role!(:admin) }

    def index
      @holidays = Holiday.current_year_and_future
    end

    def import
      Holiday.import
      redirect_to admin_holidays_path, notice: t(".notice")
    end
  end
end
