import { Controller } from "@hotwired/stimulus"

export default class extends Controller {
  connect() {
    this.scrollDown()
    this.showBubble()
  }

  scrollDown() {
    const el = this.element.closest('[id*=chat_messages_service_request_]')
    if (el !== null) {
      el.classList.remove("hidden")
      this.element.scrollIntoView()
    }
  }

  showBubble() {
    const activeTabItem = document.querySelector(".agent-call-nav-item.active")
    const chatTabItem = document.querySelector(".agent-call-nav-chat-item")
    if (chatTabItem !== null) {
      const bubble = chatTabItem.querySelector(".bubble")
      if (bubble.classList.contains("enabled") && activeTabItem != chatTabItem)
        bubble.classList.remove("hidden")
    }
  }
}
