# Set variables
set :repo_url, "git@github.com:INFOUND/warteraum-service-center.git"
set :rvm_ruby_version, "3.1.2"
set :keep_releases, 3
set :deploy_to, "/home/infound/warteraum"

# Do not overwrite certain files but symlink them
append :linked_files, "config/master.key"
append :linked_dirs, "log", "storage", "tmp/pids", "tmp/cache",
       "tmp/sockets", "vendor/bundle"

# Roles
role :app, %w[infound@oegs.derwarteraum.com]
role :web, %w[infound@oegs.derwarteraum.com]
role :db,  %w[infound@oegs.derwarteraum.com]

# Use SSH for deployment
set :ssh_options, {
  keys: %w[~/.ssh/id_rsa],
  forward_agent: true,
  auth_methods: %w[publickey password]
}

# Restart passenger and sidekiq
namespace :services do
  task :restart do
    on roles(:app) do
      execute "/opt/helpers/deploy-service-wrapper restart"
    end
  end
end

# Hook service restart into deployment sequence
after "deploy:symlink:release", "services:restart"
