service_center = ServiceCenter.first_or_create!(open: Rails.env.development?) do
  OpeningHour.find_or_create_by!(
    open: false,
    service_center:,
    week_day: 0
  )
  OpeningHour.find_or_create_by!(
    open: false,
    service_center:,
    week_day: 6
  )

  (1..4).each do |week_day|
    OpeningHour.find_or_create_by!(week_day:) do |opening_hour|
      opening_hour.service_center = service_center
      opening_hour.from = "08:00+0200"
      opening_hour.to = "18:00+0200"
    end
  end

  OpeningHour.find_or_create_by!(
    open: true,
    service_center:,
    week_day: 5,
    from: "08:00+0200",
    to: "12:00+0200"
  )
end

password = "test1234" # TODO: change to a more secure password

User.find_or_create_by!(email: "admin@warteraum.dev") do |user|
  user.update(
    role: "admin",
    first_name: "Test",
    last_name: "Admin",
    password:,
    password_confirmation: password,
    confirmed_at: Time.current,
    locale: I18n.default_locale,
    can_close_service_center: true
  )
end

User.find_or_create_by!(email: "agent@warteraum.dev") do |user|
  user.update(
    role: "agent",
    first_name: "Test",
    last_name: "Agent",
    password:,
    password_confirmation: password,
    confirmed_at: Time.current,
    locale: I18n.default_locale,
    can_close_service_center: true
  )
  user.avatar.attach(
    io: File.open("app/assets/images/woman.png"),
    filename: "woman.png"
  )
end

User.find_or_create_by!(email: "agent2@warteraum.dev") do |user|
  user.update(
    role: "agent",
    first_name: "Test",
    last_name: "Agent2",
    password:,
    password_confirmation: password,
    confirmed_at: Time.current,
    locale: I18n.default_locale
  )
  user.avatar.attach(
    io: File.open("app/assets/images/woman.png"),
    filename: "woman.png"
  )
end

User.find_or_create_by!(email: "client@warteraum.dev") do |user|
  user.update(
    role: "client",
    first_name: "Test",
    last_name: "Client",
    gender: "female",
    password:,
    password_confirmation: password,
    confirmed_at: Time.current,
    locale: I18n.default_locale
  )
end

User.find_or_create_by!(email: "client2@warteraum.dev") do |user|
  user.update(
    role: "client",
    first_name: "Test",
    last_name: "Client2",
    gender: "male",
    password:,
    password_confirmation: password,
    confirmed_at: Time.current,
    locale: I18n.default_locale
  )
end

[
  {
    first_name: "Martina",
    last_name: "Schmiedlechner",
    email: "m.schmiedlechner@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Benjamin",
    last_name: "Zöhling",
    email: "b.zoehling@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Theresa",
    last_name: "Pell",
    email: "t.pell@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Natalie",
    last_name: "Satanik",
    email: "n.satanik@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Gabriele",
    last_name: "Benedikt",
    email: "g.benedikt@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Marina",
    last_name: "Hollauf",
    email: "m.hollauf@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Susanne",
    last_name: "Sharker",
    email: "s.sharker@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Marina",
    last_name: "Hollauf",
    email: "m.hollauf@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Marlene",
    last_name: "Mayer",
    email: "m.mayer@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Gabi",
    last_name: "Benedikt",
    email: "g.benedikt@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Eunike",
    last_name: "Schwarz",
    email: "e.schwarz@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Korni",
    last_name: "Pesut",
    email: "tech-admin@oegsbarrierefrei.at",
    can_close_service_center: true
  },
  {
    first_name: "Infound",
    last_name: "Support",
    email: "warteraum-support@infound.at",
    can_close_service_center: true
  }
].each do |agent_params|
  User.find_or_create_by!(email: agent_params[:email]) do |agent|
    agent.update(
      role: "agent",
      first_name: agent_params[:first_name],
      last_name: agent_params[:last_name],
      password:,
      password_confirmation: password,
      confirmed_at: Time.current,
      locale: I18n.default_locale,
      can_close_service_center: agent_params[:can_close_service_center]
    )
    agent.avatar.attach(
      io: File.open("app/assets/images/woman.png"),
      filename: "woman.png"
    )
  end
end

# SEEDS FOR DEVELOPMENT

return unless Rails.env.development?

30.times do
  Article.create!(
    category_id: I18n.t("activerecord.attributes.service_request.categories").keys.sample,
    user: User.agent.sample,
    title: Faker::Lorem.sentence,
    content: Faker::Lorem.paragraph
  )
end

def create_service_request(client)
  ServiceRequest.create!(
    client:,
    agent: nil,
    title: Faker::Lorem.sentence,
    description: Faker::Lorem.paragraph,
    category_id: I18n.t("activerecord.attributes.service_request.categories").keys.sample
  )
end

3.times do
  create_service_request(User.client.first)
end

# 2.times do
#   create_service_request(User.client.second)
# end
