require "test_helper"

module Client
  class UsersControllerTest < ActionDispatch::IntegrationTest
    include Devise::Test::IntegrationHelpers

    test "renders the edit page" do
      sign_in user = users(:client)

      get edit_client_user_path(user)

      assert_response :ok
    end

    test "updates the user" do
      sign_in user = users(:client)

      assert_equal user.first_name, "Client"

      patch client_user_path(user), params: {
        user: { first_name: "updated" }
      }

      assert_equal user.first_name, "updated"

      assert flash[:info]
      assert_response :ok
    end
  end
end
