require "test_helper"

module Users
  class SessionsControllerTest < ActionController::TestCase
    include Devise::Test::ControllerHelpers

    test "should create anonymous user" do
      @request.env["devise.mapping"] = Devise.mappings[:user]

      sign_in users(:client)

      cookies.encrypted["client_id"] = "abc123"

      delete :destroy
      assert_redirected_to "/"

      assert_nil cookies.encrypted["client_id"]
    end
  end
end
