require "test_helper"

class ApplicationHelperTest < ActionView::TestCase
  include ApplicationHelper

  test "should render icon with default classes" do
    assert_match(/class="w-4 h-4"/, icon(:arrow_right))
  end

  test "should render icon with overridden classes" do
    output = icon(:arrow_right, icon_class: "text-blue w-8 h-8")

    assert_match(/class=".*text-blue.*"/, output)
    assert_match(/class=".*w-8 h-8.*"/, output)
    assert_no_match(/class=".*w-4 h-4.*"/, output)
  end
end
