require "simplecov"
SimpleCov.start "rails" do
  enable_coverage :branch
end

ENV["RAILS_ENV"] ||= "test"
require_relative "../config/environment"
require "rails/test_help"

module ActiveSupport
  class TestCase
    # Run tests in parallel with specified workers
    # parallelize(workers: :number_of_processors)

    # Setup all fixtures in test/fixtures/*.yml for all tests in alphabetical order.
    fixtures :all

    # Add more helper methods to be used by all tests here...

    Sidekiq::ScheduledSet.new.clear
    RecurringOpeningHour.create_view

    def mock_pg_time(timestamp)
      travel_to timestamp

      ActiveRecord::Base.connection.execute <<~SQL.squish
        CREATE SCHEMA IF NOT EXISTS mock_time;
        CREATE OR REPLACE FUNCTION mock_time.now()
        RETURNS timestamp with time zone
        AS
        $$
        BEGIN
        RETURN '#{timestamp.iso8601}'::timestamptz;
        END;
        $$
        LANGUAGE plpgsql STABLE PARALLEL SAFE STRICT;
        SET search_path = mock_time, public, pg_catalog;
      SQL

      RecurringOpeningHour.create_view
      ActiveRecord::Base.connection.clear_query_cache

      yield

      ActiveRecord::Base.connection.execute "DROP FUNCTION mock_time.now() CASCADE"

      travel_back
    end
  end
end
